/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.runtime.SignatureIterator;

public class SignatureConverter
extends SignatureIterator {
    private StringBuffer buf;
    private boolean first = true;

    public SignatureConverter(Symbol sig, StringBuffer buf) {
        super(sig);
        this.buf = buf;
    }

    @Override
    public void doBool() {
        this.appendComma();
        this.buf.append("boolean");
    }

    @Override
    public void doChar() {
        this.appendComma();
        this.buf.append("char");
    }

    @Override
    public void doFloat() {
        this.appendComma();
        this.buf.append("float");
    }

    @Override
    public void doDouble() {
        this.appendComma();
        this.buf.append("double");
    }

    @Override
    public void doByte() {
        this.appendComma();
        this.buf.append("byte");
    }

    @Override
    public void doShort() {
        this.appendComma();
        this.buf.append("short");
    }

    @Override
    public void doInt() {
        this.appendComma();
        this.buf.append("int");
    }

    @Override
    public void doLong() {
        this.appendComma();
        this.buf.append("long");
    }

    @Override
    public void doVoid() {
        if (!this.isReturnType()) {
            throw new RuntimeException("Should not reach here");
        }
        this.appendComma();
        this.buf.append("void");
    }

    @Override
    public void doObject(int begin, int end) {
        this.doObject(begin, end, true);
    }

    @Override
    public void doArray(int begin, int end) {
        this.appendComma();
        int inner = this.arrayInnerBegin(begin);
        switch (this._signature.getByteAt(inner)) {
            case 66: {
                this.buf.append("byte");
                break;
            }
            case 67: {
                this.buf.append("char");
                break;
            }
            case 68: {
                this.buf.append("double");
                break;
            }
            case 70: {
                this.buf.append("float");
                break;
            }
            case 73: {
                this.buf.append("int");
                break;
            }
            case 74: {
                this.buf.append("long");
                break;
            }
            case 83: {
                this.buf.append("short");
                break;
            }
            case 90: {
                this.buf.append("boolean");
                break;
            }
            case 76: {
                this.doObject(inner + 1, end, false);
                break;
            }
        }
        for (int i = 0; i < inner - begin + 1; ++i) {
            this.buf.append("[]");
        }
    }

    public void appendComma() {
        if (!this.first) {
            this.buf.append(", ");
        }
        this.first = false;
    }

    private void doObject(int begin, int end, boolean comma) {
        if (comma) {
            this.appendComma();
        }
        this.appendSubstring(begin, end - 1);
    }

    private void appendSubstring(int begin, int end) {
        for (int i = begin; i < end; ++i) {
            this.buf.append((char)(this._signature.getByteAt(i) & 0xFF));
        }
    }

    private int arrayInnerBegin(int begin) {
        while (this._signature.getByteAt(begin) == 91) {
            ++begin;
        }
        return begin;
    }
}

