/*
 * Decompiled with CFR 0.152.
 */
package com.ncloud.api.cli.module;

import com.beust.jcommander.JCommander;
import com.ncloud.api.cli.common.model.CommandEnum;
import com.ncloud.api.cli.common.model.CommandOption;
import com.ncloud.api.cli.common.options.GlobalOptions;
import com.ncloud.api.cli.common.util.CliCallUtil;
import com.ncloud.api.cli.common.util.CommandUtil;
import com.ncloud.api.cli.common.util.GlobalOptionUtil;
import com.ncloud.api.cli.exception.NcloudCliException;
import com.ncloud.api.cli.vautoscaling.options.CreateAutoScalingGroupOptions;
import com.ncloud.api.cli.vautoscaling.options.CreateLaunchConfigurationOptions;
import com.ncloud.api.cli.vautoscaling.options.DeleteAutoScalingGroupOptions;
import com.ncloud.api.cli.vautoscaling.options.DeleteLaunchConfigurationOptions;
import com.ncloud.api.cli.vautoscaling.options.DeleteScalingPolicyOptions;
import com.ncloud.api.cli.vautoscaling.options.DeleteScheduledActionOptions;
import com.ncloud.api.cli.vautoscaling.options.ExecutePolicyOptions;
import com.ncloud.api.cli.vautoscaling.options.GetAdjustmentTypeListOptions;
import com.ncloud.api.cli.vautoscaling.options.GetAutoScalingActivityLogListOptions;
import com.ncloud.api.cli.vautoscaling.options.GetAutoScalingGroupDetailOptions;
import com.ncloud.api.cli.vautoscaling.options.GetAutoScalingGroupListOptions;
import com.ncloud.api.cli.vautoscaling.options.GetAutoScalingPolicyListOptions;
import com.ncloud.api.cli.vautoscaling.options.GetLaunchConfigurationDetailOptions;
import com.ncloud.api.cli.vautoscaling.options.GetLaunchConfigurationListOptions;
import com.ncloud.api.cli.vautoscaling.options.GetScalingProcessTypeListOptions;
import com.ncloud.api.cli.vautoscaling.options.GetScheduledActionListOptions;
import com.ncloud.api.cli.vautoscaling.options.PutScalingPolicyOptions;
import com.ncloud.api.cli.vautoscaling.options.PutScheduledUpdateGroupActionOptions;
import com.ncloud.api.cli.vautoscaling.options.ResumeProcessesOptions;
import com.ncloud.api.cli.vautoscaling.options.SetDesiredCapacityOptions;
import com.ncloud.api.cli.vautoscaling.options.SuspendProcessesOptions;
import com.ncloud.api.cli.vautoscaling.options.UpdateAutoScalingGroupOptions;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VAutoscaling {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void execute(JCommander vAutoscalingCommander, CommandEnum.VautoscalingCommand vautoscalingCommand) throws NcloudCliException, UnsupportedEncodingException {
        JCommander subCommander = vAutoscalingCommander.getCommands().get(vautoscalingCommand.getCode());
        CommandOption commandOption = null;
        String requestUri = null;
        switch (vautoscalingCommand) {
            case getLaunchConfigurationList: {
                requestUri = "/vautoscaling/v2/getLaunchConfigurationList";
                commandOption = (GetLaunchConfigurationListOptions)subCommander.getObjects().get(0);
                break;
            }
            case getLaunchConfigurationDetail: {
                requestUri = "/vautoscaling/v2/getLaunchConfigurationDetail";
                commandOption = (GetLaunchConfigurationDetailOptions)subCommander.getObjects().get(0);
                break;
            }
            case createLaunchConfiguration: {
                requestUri = "/vautoscaling/v2/createLaunchConfiguration";
                commandOption = (CreateLaunchConfigurationOptions)subCommander.getObjects().get(0);
                break;
            }
            case deleteLaunchConfiguration: {
                requestUri = "/vautoscaling/v2/deleteLaunchConfiguration";
                commandOption = (DeleteLaunchConfigurationOptions)subCommander.getObjects().get(0);
                break;
            }
            case getAutoScalingGroupList: {
                requestUri = "/vautoscaling/v2/getAutoScalingGroupList";
                commandOption = (GetAutoScalingGroupListOptions)subCommander.getObjects().get(0);
                break;
            }
            case getAutoScalingGroupDetail: {
                requestUri = "/vautoscaling/v2/getAutoScalingGroupDetail";
                commandOption = (GetAutoScalingGroupDetailOptions)subCommander.getObjects().get(0);
                break;
            }
            case createAutoScalingGroup: {
                requestUri = "/vautoscaling/v2/createAutoScalingGroup";
                commandOption = (CreateAutoScalingGroupOptions)subCommander.getObjects().get(0);
                break;
            }
            case updateAutoScalingGroup: {
                requestUri = "/vautoscaling/v2/updateAutoScalingGroup";
                commandOption = (UpdateAutoScalingGroupOptions)subCommander.getObjects().get(0);
                break;
            }
            case deleteAutoScalingGroup: {
                requestUri = "/vautoscaling/v2/deleteAutoScalingGroup";
                commandOption = (DeleteAutoScalingGroupOptions)subCommander.getObjects().get(0);
                break;
            }
            case setDesiredCapacity: {
                requestUri = "/vautoscaling/v2/setDesiredCapacity";
                commandOption = (SetDesiredCapacityOptions)subCommander.getObjects().get(0);
                break;
            }
            case getScheduledActionList: {
                requestUri = "/vautoscaling/v2/getScheduledActionList";
                commandOption = (GetScheduledActionListOptions)subCommander.getObjects().get(0);
                break;
            }
            case putScheduledUpdateGroupAction: {
                requestUri = "/vautoscaling/v2/putScheduledUpdateGroupAction";
                commandOption = (PutScheduledUpdateGroupActionOptions)subCommander.getObjects().get(0);
                break;
            }
            case deleteScheduledAction: {
                requestUri = "/vautoscaling/v2/deleteScheduledAction";
                commandOption = (DeleteScheduledActionOptions)subCommander.getObjects().get(0);
                break;
            }
            case getScalingProcessTypeList: {
                requestUri = "/vautoscaling/v2/getScalingProcessTypeList";
                commandOption = (GetScalingProcessTypeListOptions)subCommander.getObjects().get(0);
                break;
            }
            case suspendProcesses: {
                requestUri = "/vautoscaling/v2/suspendProcesses";
                commandOption = (SuspendProcessesOptions)subCommander.getObjects().get(0);
                break;
            }
            case resumeProcesses: {
                requestUri = "/vautoscaling/v2/resumeProcesses";
                commandOption = (ResumeProcessesOptions)subCommander.getObjects().get(0);
                break;
            }
            case getAutoScalingActivityLogList: {
                requestUri = "/vautoscaling/v2/getAutoScalingActivityLogList";
                commandOption = (GetAutoScalingActivityLogListOptions)subCommander.getObjects().get(0);
                break;
            }
            case getAutoScalingPolicyList: {
                requestUri = "/vautoscaling/v2/getAutoScalingPolicyList";
                commandOption = (GetAutoScalingPolicyListOptions)subCommander.getObjects().get(0);
                break;
            }
            case getAdjustmentTypeList: {
                requestUri = "/vautoscaling/v2/getAdjustmentTypeList";
                commandOption = (GetAdjustmentTypeListOptions)subCommander.getObjects().get(0);
                break;
            }
            case putScalingPolicy: {
                requestUri = "/vautoscaling/v2/putScalingPolicy";
                commandOption = (PutScalingPolicyOptions)subCommander.getObjects().get(0);
                break;
            }
            case deleteScalingPolicy: {
                requestUri = "/vautoscaling/v2/deleteScalingPolicy";
                commandOption = (DeleteScalingPolicyOptions)subCommander.getObjects().get(0);
                break;
            }
            case executePolicy: {
                requestUri = "/vautoscaling/v2/executePolicy";
                commandOption = (ExecutePolicyOptions)subCommander.getObjects().get(0);
                break;
            }
        }
        if (null != requestUri) {
            GlobalOptions globalOptions = commandOption.getCommandOptions().getGlobalOptions();
            String profile = globalOptions.getProfile();
            boolean isDebug = GlobalOptionUtil.getIsDebug();
            if (profile == null) {
                profile = "DEFAULT";
            }
            CliCallUtil.call(globalOptions, CommandUtil.getNcloudNewApiRequest(profile, isDebug), requestUri, commandOption);
        }
    }
}

