/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.AccessController;
import java.security.SecureRandom;
import java.util.EnumSet;
import java.util.Set;
import sun.security.action.GetPropertyAction;

class TempFileHelper {
    private static final Path tmpdir = Paths.get(AccessController.doPrivileged(new GetPropertyAction("java.io.tmpdir")), new String[0]);
    private static final boolean isPosix = FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
    private static final SecureRandom random = new SecureRandom();

    private TempFileHelper() {
    }

    private static Path generatePath(String string, String string2, Path path) {
        long l = random.nextLong();
        l = l == Long.MIN_VALUE ? 0L : Math.abs(l);
        Path path2 = path.getFileSystem().getPath(string + Long.toString(l) + string2, new String[0]);
        if (path2.getParent() != null) {
            throw new IllegalArgumentException("Invalid prefix or suffix");
        }
        return path.resolve(path2);
    }

    private static Path create(Path path, String string, String string2, boolean bl, FileAttribute<?>[] fileAttributeArray) throws IOException {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            String string3 = string2 = bl ? "" : ".tmp";
        }
        if (path == null) {
            path = tmpdir;
        }
        if (isPosix && path.getFileSystem() == FileSystems.getDefault()) {
            if (fileAttributeArray.length == 0) {
                fileAttributeArray = new FileAttribute[]{bl ? PosixPermissions.dirPermissions : PosixPermissions.filePermissions};
            } else {
                boolean bl2 = false;
                for (int i = 0; i < fileAttributeArray.length; ++i) {
                    if (!fileAttributeArray[i].name().equals("posix:permissions")) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    FileAttribute[] fileAttributeArray2 = new FileAttribute[fileAttributeArray.length + 1];
                    System.arraycopy(fileAttributeArray, 0, fileAttributeArray2, 0, fileAttributeArray.length);
                    fileAttributeArray = fileAttributeArray2;
                    fileAttributeArray[fileAttributeArray.length - 1] = bl ? PosixPermissions.dirPermissions : PosixPermissions.filePermissions;
                }
            }
        }
        SecurityManager securityManager = System.getSecurityManager();
        while (true) {
            Path path2;
            try {
                path2 = TempFileHelper.generatePath(string, string2, path);
            }
            catch (InvalidPathException invalidPathException) {
                if (securityManager != null) {
                    throw new IllegalArgumentException("Invalid prefix or suffix");
                }
                throw invalidPathException;
            }
            try {
                if (bl) {
                    return Files.createDirectory(path2, fileAttributeArray);
                }
                return Files.createFile(path2, fileAttributeArray);
            }
            catch (SecurityException securityException) {
                if (path == tmpdir && securityManager != null) {
                    throw new SecurityException("Unable to create temporary file or directory");
                }
                throw securityException;
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                continue;
            }
            break;
        }
    }

    static Path createTempFile(Path path, String string, String string2, FileAttribute<?>[] fileAttributeArray) throws IOException {
        return TempFileHelper.create(path, string, string2, false, fileAttributeArray);
    }

    static Path createTempDirectory(Path path, String string, FileAttribute<?>[] fileAttributeArray) throws IOException {
        return TempFileHelper.create(path, string, null, true, fileAttributeArray);
    }

    private static class PosixPermissions {
        static final FileAttribute<Set<PosixFilePermission>> filePermissions = PosixFilePermissions.asFileAttribute(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE));
        static final FileAttribute<Set<PosixFilePermission>> dirPermissions = PosixFilePermissions.asFileAttribute(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE));

        private PosixPermissions() {
        }
    }
}

