/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLProtocolException;
import sun.security.ssl.ExtensionType;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HelloExtension;

final class ALPNExtension
extends HelloExtension {
    static final int ALPN_HEADER_LENGTH = 1;
    static final int MAX_APPLICATION_PROTOCOL_LENGTH = 255;
    static final int MAX_APPLICATION_PROTOCOL_LIST_LENGTH = 65535;
    private int listLength = 0;
    private List<String> protocolNames = null;

    ALPNExtension(String string) throws SSLException {
        this(new String[]{string});
    }

    ALPNExtension(String[] stringArray) throws SSLException {
        super(ExtensionType.EXT_ALPN);
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("The list of application protocols cannot be empty");
        }
        this.protocolNames = Arrays.asList(stringArray);
        for (String string : stringArray) {
            int n = string.getBytes(StandardCharsets.UTF_8).length;
            if (n == 0) {
                throw new SSLProtocolException("Application protocol name is empty");
            }
            if (n <= 255) {
                this.listLength += n + 1;
            } else {
                throw new SSLProtocolException("Application protocol name is too long: " + string);
            }
            if (this.listLength <= 65535) continue;
            throw new SSLProtocolException("Application protocol name list is too long");
        }
    }

    ALPNExtension(HandshakeInStream handshakeInStream, int n) throws IOException {
        super(ExtensionType.EXT_ALPN);
        int n2;
        byte[] byArray;
        if (n >= 2) {
            this.listLength = handshakeInStream.getInt16();
            if (this.listLength < 2 || this.listLength + 2 != n) {
                throw new SSLProtocolException("Invalid " + this.type + " extension: incorrect list length " + "(length=" + this.listLength + ")");
            }
        } else {
            throw new SSLProtocolException("Invalid " + this.type + " extension: insufficient data " + "(length=" + n + ")");
        }
        this.protocolNames = new ArrayList<String>();
        for (n2 = this.listLength; n2 > 0; n2 -= byArray.length + 1) {
            byArray = handshakeInStream.getBytes8();
            if (byArray.length == 0) {
                throw new SSLProtocolException("Invalid " + this.type + " extension: empty application protocol name");
            }
            String string = new String(byArray, StandardCharsets.UTF_8);
            this.protocolNames.add(string);
        }
        if (n2 != 0) {
            throw new SSLProtocolException("Invalid " + this.type + " extension: extra data " + "(length=" + n2 + ")");
        }
    }

    List<String> getPeerAPs() {
        return this.protocolNames;
    }

    @Override
    int length() {
        return 6 + this.listLength;
    }

    @Override
    void send(HandshakeOutStream handshakeOutStream) throws IOException {
        handshakeOutStream.putInt16(this.type.id);
        handshakeOutStream.putInt16(this.listLength + 2);
        handshakeOutStream.putInt16(this.listLength);
        for (String string : this.protocolNames) {
            handshakeOutStream.putBytes8(string.getBytes(StandardCharsets.UTF_8));
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.protocolNames == null || this.protocolNames.isEmpty()) {
            stringBuilder.append("<empty>");
        } else {
            for (String string : this.protocolNames) {
                stringBuilder.append("[" + string + "]");
            }
        }
        return "Extension " + this.type + ", protocol names: " + stringBuilder;
    }
}

