/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.LookupOverride;
import org.springframework.beans.factory.support.MethodOverride;
import org.springframework.beans.factory.support.MethodReplacer;
import org.springframework.beans.factory.support.ReplaceOverride;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.support.SimpleInstantiationStrategy;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.CallbackFilter;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.cglib.proxy.NoOp;

public class CglibSubclassingInstantiationStrategy
extends SimpleInstantiationStrategy {
    private static final int PASSTHROUGH = 0;
    private static final int LOOKUP_OVERRIDE = 1;
    private static final int METHOD_REPLACER = 2;

    protected Object instantiateWithMethodInjection(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner) {
        return new CglibSubclassCreator(beanDefinition, owner).instantiate(null, null);
    }

    protected Object instantiateWithMethodInjection(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner, Constructor ctor, Object[] args) {
        return new CglibSubclassCreator(beanDefinition, owner).instantiate(ctor, args);
    }

    private static class CglibSubclassCreator {
        private static final Log logger = LogFactory.getLog(CglibSubclassCreator.class);
        private final RootBeanDefinition beanDefinition;
        private final BeanFactory owner;

        public CglibSubclassCreator(RootBeanDefinition beanDefinition, BeanFactory owner) {
            this.beanDefinition = beanDefinition;
            this.owner = owner;
        }

        public Object instantiate(Constructor ctor, Object[] args) {
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(this.beanDefinition.getBeanClass());
            enhancer.setCallbackFilter(new CallbackFilterImpl());
            enhancer.setCallbacks(new Callback[]{NoOp.INSTANCE, new LookupOverrideMethodInterceptor(), new ReplaceOverrideMethodInterceptor()});
            return ctor == null ? enhancer.create() : enhancer.create(ctor.getParameterTypes(), args);
        }

        private class CallbackFilterImpl
        extends CglibIdentitySupport
        implements CallbackFilter {
            private CallbackFilterImpl() {
            }

            public int accept(Method method) {
                MethodOverride methodOverride = CglibSubclassCreator.this.beanDefinition.getMethodOverrides().getOverride(method);
                if (logger.isTraceEnabled()) {
                    logger.trace("Override for '" + method.getName() + "' is [" + methodOverride + "]");
                }
                if (methodOverride == null) {
                    return 0;
                }
                if (methodOverride instanceof LookupOverride) {
                    return 1;
                }
                if (methodOverride instanceof ReplaceOverride) {
                    return 2;
                }
                throw new UnsupportedOperationException("Unexpected MethodOverride subclass: " + methodOverride.getClass().getName());
            }
        }

        private class ReplaceOverrideMethodInterceptor
        extends CglibIdentitySupport
        implements MethodInterceptor {
            private ReplaceOverrideMethodInterceptor() {
            }

            public Object intercept(Object obj, Method method, Object[] args, MethodProxy mp) throws Throwable {
                ReplaceOverride ro = (ReplaceOverride)CglibSubclassCreator.this.beanDefinition.getMethodOverrides().getOverride(method);
                MethodReplacer mr = (MethodReplacer)CglibSubclassCreator.this.owner.getBean(ro.getMethodReplacerBeanName());
                return mr.reimplement(obj, method, args);
            }
        }

        private class LookupOverrideMethodInterceptor
        extends CglibIdentitySupport
        implements MethodInterceptor {
            private LookupOverrideMethodInterceptor() {
            }

            public Object intercept(Object obj, Method method, Object[] args, MethodProxy mp) throws Throwable {
                LookupOverride lo = (LookupOverride)CglibSubclassCreator.this.beanDefinition.getMethodOverrides().getOverride(method);
                return CglibSubclassCreator.this.owner.getBean(lo.getBeanName());
            }
        }

        private class CglibIdentitySupport {
            private CglibIdentitySupport() {
            }

            protected RootBeanDefinition getBeanDefinition() {
                return CglibSubclassCreator.this.beanDefinition;
            }

            public boolean equals(Object other) {
                return other.getClass().equals(this.getClass()) && ((CglibIdentitySupport)other).getBeanDefinition().equals(CglibSubclassCreator.this.beanDefinition);
            }

            public int hashCode() {
                return CglibSubclassCreator.this.beanDefinition.hashCode();
            }
        }
    }
}

