/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.support.NoOpCacheManager;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeCacheManager
implements InitializingBean,
CacheManager {
    private List<CacheManager> cacheManagers;
    private boolean fallbackToNoOpCache = false;

    public void setCacheManagers(Collection<CacheManager> cacheManagers) {
        Assert.notEmpty(cacheManagers, "cacheManagers Collection must not be empty");
        this.cacheManagers = new ArrayList<CacheManager>();
        this.cacheManagers.addAll(cacheManagers);
    }

    public void setFallbackToNoOpCache(boolean fallbackToNoOpCache) {
        this.fallbackToNoOpCache = fallbackToNoOpCache;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.fallbackToNoOpCache) {
            this.cacheManagers.add(new NoOpCacheManager());
        }
    }

    @Override
    public Cache getCache(String name) {
        for (CacheManager cacheManager : this.cacheManagers) {
            Cache cache = cacheManager.getCache(name);
            if (cache == null) continue;
            return cache;
        }
        return null;
    }

    @Override
    public Collection<String> getCacheNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (CacheManager manager : this.cacheManagers) {
            names.addAll(manager.getCacheNames());
        }
        return Collections.unmodifiableList(names);
    }
}

