/*
 * Decompiled with CFR 0.152.
 */
package com.ncloud.api.cli.common.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.ncloud.api.cli.common.model.CommonResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthUtil {
    private static final Logger logger = LoggerFactory.getLogger(AuthUtil.class);

    public static Map<String, Object> getApiHeaders(String timestampString, String accessKey, String signature) {
        HashMap<String, Object> httpHeaders = new HashMap<String, Object>();
        httpHeaders.put("x-ncp-apigw-timestamp", timestampString);
        httpHeaders.put("x-ncp-iam-access-key", accessKey);
        httpHeaders.put("x-ncp-apigw-signature-v2", signature);
        return httpHeaders;
    }

    public static CommonResponse getCommonResponseByFormat(String responseFormatType, String body) throws IOException {
        String rootName2 = "";
        ObjectMapper mapper = null;
        if (responseFormatType.equals("json")) {
            mapper = new ObjectMapper();
            Map bodyMap = mapper.readValue(body, Map.class);
            Set key = bodyMap.keySet();
            for (String rootName2 : key) {
            }
        } else if (responseFormatType.equals("xml")) {
            mapper = new XmlMapper();
        }
        CommonResponse commonResponse = mapper.convertValue(mapper.reader(Map.class).withRootName(rootName2).readValue(body), CommonResponse.class);
        return commonResponse;
    }

    public static String makeSignature(String method, String uri, String timestamp, String accessKey, String secretKey) {
        String message = method + " " + uri + "\n" + timestamp + "\n" + accessKey;
        String encodeBase64String = null;
        try {
            SecretKeySpec signingKey = new SecretKeySpec(secretKey.getBytes("UTF-8"), "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(message.getBytes("UTF-8"));
            encodeBase64String = Base64.encodeBase64String(rawHmac).replaceAll("(\\r|\\n)", "");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        return encodeBase64String;
    }
}

